<?php
/** MILLDONE
 * Template for displaying contact information on property cards
 * src: templates\property_cards_templates\property_card_details_templates\property_card_contact.php
 * This template is part of the WpResidence theme and is used to show
 * contact options for the property agent, including call, email, and WhatsApp.
 * It creates a contact wrapper and two modal dialogs for call and email actions.
 *
 * @package WpResidence
 * @subpackage PropertyCard
 * @since WpResidence 1.0
 */


 
// Retrieve agent ID associated with the property from cache
$agentID = intval(wpestate_return_data_from_cache_if_exists($property_unit_cached_data, $postID, 'meta', 'property_agent'));
$agentType = get_post_type($agentID);

// Apply WPML filter if the function exists
if (function_exists('icl_translate')) {
    $agentID = apply_filters('wpml_object_id', $agent_id, $agentType);
}

// Retrieve cached agent data based on the agent ID
//$property_agent_cached_data = wpestate_api_get_cached_post_data($agentID, 'estate_agent');
if(function_exists('wpestate_api_get_cached_post_data')){
    $property_agent_cached_data = wpestate_api_get_cached_post_data($agentID, $agentType);
}else{
    $property_agent_cached_data =array();
}
// Retrieve agent details for the current property
$realtor_details = wpestate_return_agent_details_from_cache($property_agent_cached_data,$agentID,$postID);

// Generate WhatsApp message link
$whatsapp_message = wpestate_return_agent_whatsapp_call($postID, $realtor_details['realtor_mobile']);

// Check if call modal should be shown (theme option)
$wp_estate_call_show_modal_unit7 = esc_html(wpresidence_get_option('wp_estate_call_show_modal_unit7', ''));




?>

<!-- Main contact wrapper -->
<div class="wpestate_property_card_contact_wrapper">
    <?php
    // Determine whether to use a div or an anchor for the phone element
    $phone_element = $wp_estate_call_show_modal_unit7 == 'yes' ? 'div' : 'a';
    
    // Set appropriate attributes for the phone element
    $phone_attributes = $wp_estate_call_show_modal_unit7 == 'yes'
        ? 'data-item-id="' . $postID . '"'  // For modal trigger
        : 'target="_blank" href="tel:' . esc_attr($realtor_details['realtor_phone']) . '"';  // For direct call
    ?>
    
    <!-- Phone contact element -->
    <<?php echo $phone_element; ?> class="wpestate_property_card_contact_wrapper_phone" <?php echo $phone_attributes; ?>>
        <?php
        // Include phone icon SVG
        include(locate_template('css/css-images/icons/contact-call-7.svg'));
        esc_html_e('Call', 'wpresidence');
        ?>
    </<?php echo $phone_element; ?>>

    <!-- Email contact element -->
    <div class="wpestate_property_card_contact_wrapper_email" data-item-id="<?php echo $postID; ?>">
        <i class="far fa-envelope"></i> <?php esc_html_e('Email', 'wpresidence'); ?>
    </div>

    <!-- WhatsApp contact element -->
    <div class="wpestate_property_card_contact_wrapper_whatsupp">
        <a href="<?php echo esc_url($whatsapp_message); ?>" target="_blank">
            <i class="fab fa-whatsapp"></i>
        </a>
    </div>
</div>

<!-- Modal for phone call action -->
<div class="modal wpestate_card_unit_call wpestate_card_unit_call_<?php echo $postID; ?>" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <!-- Close button for modal, using Bootstrap 5.3 classes -->
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="<?php esc_attr_e('Close', 'wpresidence'); ?>"></button>
            </div>
            <div class="modal-body">
                <!-- Display call content, generated by a custom function -->
                <p><?php echo wpestate_card7_call_content($postID, $realtor_details); ?></p>
            </div>      
        </div>
    </div>
</div>

<!-- Modal for email action -->
<div class="modal wpestate_card_unit_email wpestate_card_unit_email_<?php echo $postID; ?>" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <!-- Close button for modal, using Bootstrap 5.3 classes -->
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="<?php esc_attr_e('Close', 'wpresidence'); ?>"></button>
            </div>
            <div class="modal-body wpestate_contact_form_parent">
               <?php
               // Get the agent's WordPress user ID
                $agent_wid = $realtor_details['agent_id'];
                if(isset($context)){
                    $backup_context = $context;
                }
              
                // Check if the agent is not an administrator
                if (get_the_author_meta('user_level', $agent_wid) != 10) {
                    // Include the agent widget sidebar template
                    include(locate_template('templates/agent_unit_widget_sidebar.php'));
                    
                    // Set context for the contact form
                    $context = 'sidebar_page';
                 
                    // Include the property page contact form
                    include(locate_template('/templates/listing_templates/contact_form/property_page_contact_form.php'));
                }

                // Display a message if the property is assigned to an admin instead of an agent
                if (intval($realtor_details['one_id']) == 1 && intval($realtor_details['agent_id']) == 0) {
                    esc_html_e('Looks like the property is assigned to an administrator. Please assign it to an agent or user with complete contact details.', 'wpresidence');
                }
                if(isset($backup_context)){
                    $context = $backup_context;
                }
           
               ?>
            </div>      
        </div>
    </div>
</div>